#include <bits/stdc++.h>
using namespace std;

struct Vector {
    long long x, y;

    Vector operator-(const Vector& other) const {
        Vector t;
        t.x = this->x - other.x;
        t.y = this->y - other.y;
        return t;
    }


    bool operator==(const Vector& other) const {
        return (this->x == other.y) && (this->y == other.y);
    }
};

const int MAXN = 100005;
Vector tacke[MAXN];

map<pair<int, int>, int> mapi;

long long cross(Vector a, Vector b) {
    // cout << "cross: " << endl;
    // cout << a.x << ' ' << a.y << endl;
    // cout << b.x << ' ' << b.y << endl;
    // cout << endl;
    return a.x * b.y - a.y * b.x;
}

int orientacija (Vector a, Vector b, Vector c) {
    // 	cout << "orientacija: " << endl;
    // cout << a.x << ' ' << a.y << endl;
    // cout << b.x << ' ' << b.y << endl;
    // cout << c.x << ' ' << c.y << endl;
    // cout << endl;
    long long t = cross(b - a, c - b); // ??
    if (t < 0) return -1;
    else if (t > 0) return +1;
    else  return 0;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    cout.tie(0);


    int n;
    //cout << "N: " << n << endl;
    cin >> n;


    for (int i = 0; i < n; i++) {
        cin >> tacke[i].x >> tacke[i].y;
    }


    Vector t0 = *min_element(tacke, tacke + n, [](const Vector& a, const Vector& b) {
        return make_pair(a.y, a.x) < make_pair(b.y, b.x);
    });

    sort(tacke, tacke + n, [&t0](const Vector& a, const Vector& b) {
        int o = orientacija(t0, a, b);
        if (o == 0)
            return (t0.x-a.x)*(t0.x-a.x) + (t0.y-a.y)*(t0.y-a.y)
                   < (t0.x-b.x)*(t0.x-b.x) + (t0.y-b.y)*(t0.y-b.y);
        return o < 0;
    });
    for (int i = 0; i < n; i++) {
        mapi[{tacke[i].x, tacke[i].y}] = i; 
    }
    // cout << "tacke ------------ "<< endl;
    // for (int i = 0; i < n; i++) {
    // 	cout << tacke[i].x << " " << tacke[i].y << '\n';
    // }
    // cout << "tacke ------------ "<< endl;

    vector<Vector> hull;
    for (int i = 0; i < n; i++) {
        while(hull.size() > 1 && orientacija(hull[hull.size() - 2], hull[hull.size() - 1], tacke[i]) >= 0) {
            // cout << "ori" <<endl;
            // cout << hull[hull.size() - 2].x << " " << hull[hull.size() - 2].y << endl;
            // cout << hull[hull.size() - 1].x << " " << hull[hull.size() - 1].y << endl;
            // cout << tacke[i].x << " " << tacke[i].y << '\n';
            // cout << orientacija(hull[hull.size() - 2], hull[hull.size() - 1], tacke[i]) << endl;
            // cout << endl;
            hull.pop_back();
        }
        hull.push_back(tacke[i]);
    }


    if (hull.size() == 2 && hull[0] == hull[1])
        hull.pop_back();

    int hs = hull.size();
    // cout << hs  << endl;
    // cout << hull[hs - 1].x << " " << hull[hs - 1].y << endl;
    // for (int i = 0; i < hs - 1; i++) {
    //     cout << hull[i].x << " " << hull[i].y << '\n';
    // }
    // cin >> n;

    long long area = 0;

    for (int i = 0; i < hs; i++) {
        int j = (i + 1) % hs;
        area += -cross(hull[i], hull[j] - hull[i]);
       // cout << area << endl;
    }
    //cout << area << endl;

    long long ans = LONG_LONG_MIN;
    for (int k = 0; k < hs; k++) {
        int i = mapi[{hull[k].x, hull[k].y}];
        //cout << i << endl;
        int pre = (i - 1 + n) % n;
        int pos = (i + 1) % n;
       // cout << pre << " " << pos << endl;

        long long temp = -cross(tacke[i] - tacke[pre], tacke[pos] - tacke[i]);
      //  cout << temp << endl;
        ans = max(ans, temp);
    }
    cout << (area - ans) / 2 << endl;

    return 0;
}